<?php
	if (!class_exists('TS_COMPOSIUM_SETTINGS')){
		class TS_COMPOSIUM_SETTINGS {
			function __construct() {
                // Define Class Variables
                $this->TS_VCSC_Settings_PostData                                = array();
                $this->TS_VCSC_Settings_Defaults                                = array();
                $this->TS_VCSC_Settings_Inputs                                  = array();
                $this->TS_VCSC_Settings_Custom                                  = array();
                $this->TS_VCSC_Settings_Finalized                               = array();
                $this->TS_VCSC_Settings_UnsetMe                                 = array(
                    "TS_VCSC_Variable_Elements",
                    "TS_VCSC_Variable_Deprecated",
                    "TS_VCSC_Variable_ThirdParty",
                    "TS_VCSC_Variable_Demos",
                    "TS_VCSC_Variable_WooCommerce",
                    "TS_VCSC_Variable_bbPress",
                    "TS_VCSC_Variable_Holder",
                    "TS_VCSC_Variable_KillLight",
                    "TS_VCSC_Variable_CustomLight",
                    "TS_VCSC_Variable_CustomColor",
                    "TS_VCSC_Variable_DefaultAnimation",
                    "TS_VCSC_Variable_ShareNetworks",
                    "TS_VCSC_Variable_DefaultSocialAPIs",
                    "TS_VCSC_Variable_ColorUsage",
                    "TS_VCSC_Variable_ColorBacklight",
                    "TS_VCSC_Variable_ArrayKey",
                    "TS_VCSC_Variable_ArrayValue",
                    "TS_VCSC_Variable_IsDeprecated",
                    "TS_VCSC_Variable_IsExternal",
                );
                // Read-In of Default Settings
                $this->TS_Setting_Defaults();
                // Read-In of Input Settings
                $this->TS_Settings_Inputs();
            }

            function TS_Setting_Defaults() {
                $this->TS_VCSC_Settings_Defaults                                = array(
                    // General Settings
                    'general'                                           => array(
                        'useextendedsettings'                           => false,                     // $ts_vcsc_extend_settings_allowFullOptions = get_option('ts_vcsc_extend_settings_allowFullOptions', 0);
                        'useautoupdate'                                 => true,                      // $ts_vcsc_extend_settings_allowAutoUpdate = get_option('ts_vcsc_extend_settings_allowAutoUpdate', 1);
                        'useownmenuentry'                               => true,                      // $ts_vcsc_extend_settings_mainmenu = get_option('ts_vcsc_extend_settings_mainmenu', 1);
                        'uselanguagedomain'                             => true,                      // $ts_vcsc_extend_settings_translationsDomain = get_option('ts_vcsc_extend_settings_translationsDomain', 1);
                        'usedashboardpanel'                             => false,                     // $ts_vcsc_extend_settings_dashboard = get_option('ts_vcsc_extend_settings_dashboard', 0);
                        'useiconicumgenerator'                          => array(
                            'iconmenugenerator'                             => false,                 // $ts_vcsc_extend_settings_useMenuGenerator = get_option('ts_vcsc_extend_settings_useMenuGenerator', 0);
                            'icontinymcegenerator'                          => false,                 // $ts_vcsc_extend_settings_useIconGenerator = get_option('ts_vcsc_extend_settings_useIconGenerator', 0);
                            'icontinymceposttypes'                          => "",                      // $ts_vcsc_extend_settings_usePostTypes = get_option('ts_vcsc_extend_settings_usePostTypes', '');
                        ),
                        'usevariablespriority'                          => 6,                         // $ts_vcsc_extend_settings_variablesPriority = get_option('ts_vcsc_extend_settings_variablesPriority', '6');
                        'shortcodesinwidgets'                           => true,                      // $ts_vcsc_extend_settings_allowShortcodesWidgets = get_option('ts_vcsc_extend_settings_allowShortcodesWidgets', 1);
                        'shortcodesinbackend'                           => false,                     // $ts_vcsc_extend_settings_shortcodesalways = get_option('ts_vcsc_extend_settings_shortcodesalways', 0);
                        'managergooglefonts'                            => true,                      // $ts_vcsc_extend_settings_allowGoogleManager = get_option('ts_vcsc_extend_settings_allowGoogleManager', 1);
                        'managercustomfonts'                            => false,                     // $ts_vcsc_extend_settings_allowCustomManager = get_option('ts_vcsc_extend_settings_allowCustomManager', 0);
                        'managerdowntime'                               => false,                     // $ts_vcsc_extend_settings_allowDowntimeManager = get_option('ts_vcsc_extend_settings_allowDowntimeManager', 0);
                        'managersidebars'                               => false,                     // $ts_vcsc_extend_settings_allowSidebarsManager = get_option('ts_vcsc_extend_settings_allowSidebarsManager', 0);
                        'allowautoparagraph'                            => true,                      // $ts_vcsc_extend_settings_allowAutoParagraphs = get_option('ts_vcsc_extend_settings_allowAutoParagraphs', 1);
                        'allowsanitizecontent'                          => false,                     // $ts_vcsc_extend_settings_sanitizeContent = get_option('ts_vcsc_extend_settings_sanitizeContent', 0);
                        'allowsanitizescope'                            => "remove",                    // $ts_vcsc_extend_settings_sanitizeScope = get_option('ts_vcsc_extend_settings_sanitizeScope', 'remove');
                    ),
                    // WP Bakery Page Builder: Elements
                    'pagebuildermainelements'                           => array(
                        'elementsstandard'                                  => array(),
                        'elementsdeveloper'                                 => array(),
                        'elementswoocommerce'                               => array(),
                        'elementsbbpress'                                   => array(),
                        'elementsthirdparties'                              => array(),
                        'elementsdeprecated'                                => array(
                            'deprecatedelements'                            => array(),
                            'deprecatedselector'                            => false,
                        ),
                        'elementspagenavigator'                             => false,
                        'elementssyntaxhighlighter'                         => array(
                            'syntaxhighlighteruse'                              => false,
                            'syntaxhighlightertheme'                            => false,
                        ),
                    ),
                    // WP Bakery Page Builder: Sections, Rows, Columns
                    'pagebuilderstructure'                              => array(
                        'rowsadditions'                                     => array(
                            'useadditionsrows'                                  => false,
                            'usebackgroundindicator'                            => true,
                            'usebreakpoint'                                     => 600,
                            'useoffset'                                         => 0,
                            'usevisibility'                                     => array(
                                'Large Devices'                                     => 1200,
                                'Medium Devices'                                    => 992,
                                'Small Devices'                                     => 768,
                            ),
                        ),
                        'rowscustomizer'                                    => array(
                            "globals"                                           => array (
                                "enabled"                                           => false,
                                "rowheight"                                         => false,
                                "rowwidth"                                          => false,
                                "general"                                           => false,
                                "visibility"                                        => false,
                                "columnheight"                                      => false,
                                "viewport"                                          => false,
                            ),
                            "backgrounds"                                       => array (
                                "enabled"                                           => false,
                                "imagesingle"                                       => false,
                                "imagefixed"                                        => false,
                                "imageslider"                                       => false,
                                "imageparallax"                                     => false,
                                "imageautomove"                                     => false,
                                "imagemovement"                                     => false,
                                "colorsingle"                                       => false,
                                "colorgradient"                                     => false,
                                "otherpatternbold"                                  => false,
                                "otherparticles"                                    => false,
                                "othertriangle"                                     => false,
                                "videoyoutube"                                      => false,
                                "videohtml5"                                        => false,
                            ),
                            "effects"                                           => array(
                                "enabled"                                           => false,
                                "overlays"                                          => false,
                                "kenburns"                                          => false,
                                "seperators"                                        => false,
                                "blurring"                                          => false,
                            ),
                        ),
                        'columnsadditions'                                  => false,
                        'usesmoothscroll'                                   => false,
                    ),
                    // WP Bakery Page Builder: Other Additions
                    'pagebuilderother'                                  => array(
                        'usecontainertoggle'                                => false,                   // $ts_vcsc_extend_settings_containerToggle = get_option('ts_vcsc_extend_settings_containerToggle', 0);
                        'useelementfilter'                                  => false,                   // $ts_vcsc_extend_settings_elementFilter = get_option('ts_vcsc_extend_settings_elementFilter', 0);
                        'useextendednesting'                                => false,                   // $ts_vcsc_extend_settings_allowExtendedNesting = get_option('ts_vcsc_extend_settings_allowExtendedNesting', 0);
                        'useshortcodeviewer'                                => false,                   // $ts_vcsc_extend_settings_allowShortcodeViewer = get_option('ts_vcsc_extend_settings_allowShortcodeViewer', 0);                        
                        'useimagepreview'                                   => true,                    // $ts_vcsc_extend_settings_previewImages = get_option('ts_vcsc_extend_settings_previewImages', 1);
                        'usebackendpreview'                                 => true,                    // $ts_vcsc_extend_settings_backendPreview = get_option('ts_vcsc_extend_settings_backendPreview', 1);
                        'usefrontendeditor'                                 => true,                    // $ts_vcsc_extend_settings_frontendEditor = get_option('ts_vcsc_extend_settings_frontendEditor', 1);
                        'usewpautoparagraph'                                => true,                    // $ts_vcsc_extend_settings_allowWPBBuilderWPAutoP = get_option('ts_vcsc_extend_settings_allowWPBBuilderWPAutoP', 1);
                        'usetinymceencoded'                                 => true,                    // $ts_vcsc_extend_settings_tinymceEncoded = get_option('ts_vcsc_extend_settings_tinymceEncoded', 1);
                        'usevisualiconpicker'                               => array(
                            'iconpickerutilize'                                 => true,                // $ts_vcsc_extend_settings_visualSelector = get_option('ts_vcsc_extend_settings_visualSelector', 1);
                            'iconpickerpagination'                              => 200,                 // $ts_vcsc_extend_settings_nativePaginator = get_option('ts_vcsc_extend_settings_nativePaginator', '200');
                        ),
                        'usevisuallinkpicker'                               => array(                   // $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Advanced_Linkpicker_Defaults
                            'enabled'                                           => false,
                            'global'                                            => true,
                            'offset'                                            => 25,
                            'posts'                                             => true,
                            'custom'                                            => false,
                            'orderby'                                           => 'title',
                            'order'                                             => 'ASC',
                        ),
                        'usenvisualouislider'                               => array(
                            'enabled'                                           => true,
                            'pips'                                              => false,
                            'tooltip'                                           => false,
                            'input'                                             => true,
                        ),
                    ),
                    // WP Bakery Page Builder: Icon Fonts
                    'pagebuildericonfonts'                              => array(
                        'active'                                            => array(),
                        'alwaysload'                                        => array(),
                    ),
                    // Custom Icon Fonts
                    'customiconfonts'                                   => array(
                        'active'                                            => array(),
                        'alwaysload'                                        => array(),
                    ),
                    // Built-In Kraut Lightbox
                    'krautlightbox'                                     => array(
                        'usekrautlightbox'                                  => true,                  // $ts_vcsc_extend_settings_builtinLightbox = get_option('ts_vcsc_extend_settings_builtinLightbox', 1);
                        'usetinymceintegration'                             => false,                 // $ts_vcsc_extend_settings_lightboxIntegration = get_option('ts_vcsc_extend_settings_lightboxIntegration', 0);
                        'useprettyphotooverride'                            => false,                 // $ts_vcsc_extend_settings_lightboxPrettyPhoto = get_option('ts_vcsc_extend_settings_lightboxPrettyPhoto', 0);
                        'useattachallothermedia'                            => false,                 // $ts_vcsc_extend_settings_lightboxAttachAllOther = get_option('ts_vcsc_extend_settings_lightboxAttachAllOther', 0);
                        'uselightboxinternals'                              => array(                   // $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Setting_Defaults
                            'thumbs'                                            => 'bottom',
                            'thumbsize'                                         => 50,
                            'animation'                                         => 'random',
                            'captions'                                          => 'data-title',
                            'closer'                                            => true,
                            'duration'                                          => 5000,
                            'save'                                              => false,
                            'share'                                             => false,
                            'loadapis'                                          => true,
                            'social'                                            => 'fb,tw,pin',
                            'notouch'                                           => true,
                            'bgclose'                                           => true, 
                            'nohashes'                                          => true,
                            'keyboard'                                          => true,
                            'fullscreen'                                        => true,
                            'zoom'                                              => true,
                            'fxspeed'                                           => 300,
                            'scheme'                                            => 'dark',
                            'controls'                                          => 'circle',
                            'removelight'                                       => false,
                            'customlight'                                       => false,
                            'customcolor'                                       => '#ffffff',
                            'backlight'                                         => '#ffffff',
                            'usecolor'                                          => false,
                            'urlcolorscan'                                      => false,
                            'background'                                        => '',
                            'repeat'                                            => 'no-repeat',
                            'overlay'                                           => '#000000',
                            'noise'                                             => '',
                            'cors'                                              => false,
                            'tapping'                                           => true,
                            'scrollblock'                                       => 'js',
                            'protection'                                        => 'none',
                            'historyclose'                                      => false,
                            'customscroll'                                      => true,
                        )
                    ),
                    // Custom Post Types
                    'posttypes'                                         => array(
                        'postwidgets'                                       => false,                 // $ts_vcsc_extend_settings_customWidgets = get_option('ts_vcsc_extend_settings_customWidgets', 0);
                        'postteams'                                         => false,                 // $ts_vcsc_extend_settings_customTeam = get_option('ts_vcsc_extend_settings_customTeam', 0);
                        'posttestimonials'                                  => false,                 // $ts_vcsc_extend_settings_customTestimonial = get_option('ts_vcsc_extend_settings_customTestimonial', 0);
                        'postskillsets'                                     => false,                 // $ts_vcsc_extend_settings_customSkillset = get_option('ts_vcsc_extend_settings_customSkillset', 0);
                        'posttimelines'                                     => false,                 // $ts_vcsc_extend_settings_customTimelines = get_option('ts_vcsc_extend_settings_customTimelines', 0);
                        'postlogos'                                         => false,                 // $ts_vcsc_extend_settings_customLogo = get_option('ts_vcsc_extend_settings_customLogo', 0);
                        'postlayers'                                        => false,                 // $ts_vcsc_extend_settings_customLayers = get_option('ts_vcsc_extend_settings_customLayers', 0);
                        'postsautoassignment'                               => true,                  // $ts_vcsc_extend_settings_allowAutoAssignment = get_option('ts_vcsc_extend_settings_allowAutoAssignment', 1);
                        'postpositions'                                     => array(                   // $TS_VCSC_Menu_Positions = get_option('ts_vcsc_extend_settings_menuPositions', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Menu_Positions_Defaults);
                            'ts_widgets'                                        => 50,
                            'ts_timeline'                                       => 51,
                            'ts_team'                                           => 52,
                            'ts_testimonials'                                   => 53,
                            'ts_skillsets'                                      => 54,
                            'ts_logos'                                          => 55,
                            'ts_layers'                                         => 56,
                            'ts_downtime'                                       => 57,
                        ),
                    ),
                    // External API's
                    'externalapis'                                      => array(
                        'apigooglemaps'                                     => "",
                        'apiyoutube'                                        => "",
                    ),
                    // Language Strings
                    'languagestrings'                                   => array(
                        'googlemapsold'                                     => array(               // $TS_VCSC_Google_Map_Language = get_option('ts_vcsc_extend_settings_translationsGoogleMap', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Google_Map_Language_Defaults);
                            'TextCalcShow'                                  => 'Show Address Input',
                            'TextCalcHide'                                  => 'Hide Address Input',
                            'TextDirectionShow'                             => 'Show Directions',
                            'TextDirectionHide'                             => 'Hide Directions',
                            'TextResetMap'                                  => 'Reset Map',
                            'PrintRouteText' 			                    => 'Print Route',
                            'TextViewOnGoogle'                              => 'View on Google',
                            'TextButtonCalc'                                => 'Show Route',
                            'TextSetTarget'                                 => 'Please enter your Start Address:',
                            'TextGeoLocation'                               => 'Get My Location',
                            'TextTravelMode'                                => 'Travel Mode',
                            'TextDriving'                                   => 'Driving',
                            'TextWalking'                                   => 'Walking',
                            'TextBicy'                                      => 'Bicycling',
                            'TextWP'                                        => 'Optimize Waypoints',
                            'TextButtonAdd'                                 => 'Add Stop on the Way',
                            'TextDistance'                                  => 'Total Distance:',
                            'TextMapHome'                                   => 'Home',
                            'TextMapBikes'                                  => 'Bicycle Trails',
                            'TextMapTraffic'                                => 'Traffic',
                            'TextMapSpeedMiles'                             => 'Miles Per Hour',
                            'TextMapSpeedKM'                                => 'Kilometers Per Hour',
                            'TextMapNoData'                                 => 'No Data Available!',
                            'TextMapMiles'                                  => 'Miles',
                            'TextMapKilometes'                              => 'Kilometers',
                            'TextMapActivate'                               => 'Show Google Map',
                            'TextMapDeactivate'                             => 'Hide Google Map',
                        ),
                        'googlemapsplus'                                    => array(               // $TS_VCSC_Google_MapPLUS_Language = get_option('ts_vcsc_extend_settings_translationsGoogleMapPLUS', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Google_MapPLUS_Language_Defaults);
                            'ListenersStart'                                => 'Start Listeners',
                            'ListenersStop'                                 => 'Stop Listeners',
                            'MobileShow'                                    => 'Show Google Map',
                            'MobileHide'                                    => 'Hide Google Map',
                            'StyleDefault'                                  => 'Google Standard',
                            'StyleLabel'                                    => 'Change Map Style',
                            'FilterAll'                                     => 'All Groups',
                            'FilterLabel'                                   => 'Filter by Groups',
                            'SelectLabel'                                   => 'Zoom to Location',
                            'ControlsOSM'                                   => 'Open Street',
                            'ControlsHome'                                  => 'Home',
                            'ControlsBounds'                                => 'Fit All',
                            'ControlsBike'                                  => 'Bicycle Trails',
                            'ControlsTraffic'                               => 'Traffic',
                            'ControlsTransit'                               => 'Transit',
                            'TrafficMiles'                                  => 'Miles per Hour',
                            'TrafficKilometer'                              => 'Kilometers per Hour',
                            'TrafficNone'                                   => 'No Data Available',
                            'SearchButton'                                  => 'Find New Location',
                            'SearchHolder'                                  => 'Enter new location to find ...',
                            'SearchGoogle'                                  => 'View on Google Maps',
                            'SearchDirections'                              => 'Get Directions',
                            'SearchGroup'                                   => 'Map Search',
                            'OtherLink'                                     => 'Learn More!',
                            'PlaceholderMarker'                             => 'Select Location',
                            'ListingsButton'                                => 'Search Locations',
                            'ListingsSearch'                                => 'Enter existing location to search for ...',
                            'SumoConfirm'                                   => 'Confirm',
                            'SumoCancel'                                    => 'Cancel',
                            'SumoSelected'                                  => 'Selected',
                            'SumoAllSelected'                               => 'All Selected!',
                            'SumoPlaceholder'                               => 'Select Here',
                            'SumoSearchLocations'                           => 'Search Locations',
                            'SumoSearchGroups'                              => 'Search Groups',
                            'SumoSearchStyles'                              => 'Search Styles',
                        ),
                        'countdown'                                         => array(               // $TS_VCSC_Countdown_Language = get_option('ts_vcsc_extend_settings_translationsCountdown', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Countdown_Language_Defaults);
                            'DayPlural'                                     => 'Days',
                            'DaySingular'                                   => 'Day',
                            'HourPlural'                                    => 'Hours',
                            'HourSingular'                                  => 'Hour',
                            'MinutePlural'                                  => 'Minutes',
                            'MinuteSingular'                                => 'Minute',
                            'SecondPlural'                                  => 'Seconds',
                            'SecondSingular'                                => 'Second',
                        ),
                        'imagemagnify'                                      => array(               // $TS_VCSC_Magnify_Language = get_option('ts_vcsc_extend_settings_translationsMagnify', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Magnify_Language_Defaults);
                            'ZoomIn'                                        => 'Zoom In',
                            'ZoomOut'                                       => 'Zoom Out',
                            'ZoomLevel'                                     => 'Zoom Level',
                            'ChangeLevel'                                   => 'Change Zoom Level',
                            'Next'                                          => 'Next',
                            'Previous'                                      => 'Previous',
                            'Reset'                                         => 'Reset Zoom',
                            'Rotate'                                        => 'Rotate Image',
                            'Lightbox'                                      => 'Show Image in Lightbox',
                        ),
                        'loancalculator'                                    => array(               // $TS_VCSC_LoanCalculator_Language = get_option('ts_vcsc_extend_settings_translationsLoanCalculator', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Loan_Calculator_Language_Defaults);
                            'settings_title'                                => 'Enter Loan Information:',
                            'settings_results'                              => 'Loan Results (Fixed Term):',
                            'baseline_message'                              => 'Select the unknown loan variable you want to determine, based on all other provided loan information:',
                            'baseline_payment'                              => 'Payment Amount',
                            'baseline_term'                                 => 'Amortization Term',
                            'baseline_principal'                            => 'Loan Amount',
                            'principal_label'                               => 'Loan Amount (Principal):',
                            'principal_error'                               => 'Please provide a valid value for the loan amount!',
                            'interest_label'                                => 'Annual Interest Rate (%):',
                            'interest_error'                                => 'Please provide a valid value for the interest rate!',
                            'years_label'                                   => 'Amortization Term in Years:',
                            'years_error'                                   => 'Please provide a valid value for the desired loan amortization!',
                            'payment_label'                                 => 'Payment Amount:',
                            'payment_error'                                 => 'Please provide a valid value for the desired payment amount!',
                            'fixed_label'                                   => 'Interest Fixed Term:',
                            'fixed_match'                                   => 'Match Amortization Term',
                            'frequency_label'                               => 'Payment Frequency:',
                            'compounding_label'                             => 'Compounding Method:',
                            'compounding_simple'                            => 'Simple Interest (No Compounding)',
                            'compounding_monthly'                           => 'Monthly Compounding',
                            'compounding_quarter'                           => 'Quarterly Compounding',
                            'compounding_semi'                              => 'Semi-Annual Compounding',
                            'compounding_annual'                            => 'Annual Compounding',
                            'origination_label'                             => 'Loan Origination Date:',
                            'origination_error'                             => 'Please provide a valid value for the origination date, using the format yyyy-mm-dd!',
                            'disclaimer_message'                            => 'This loan calculator will only provide you with estimates; you will receive the final and accurate loan breakdown from your lender at the time of closing.',
                            'button_calculate'                              => 'Calculate Loan',
                            'button_reset'                                  => 'Reset Calculator',
                            'button_chartshow'                              => 'Show Chart',
                            'button_charthide'                              => 'Hide Chart',
                            'button_chartsave'                              => 'Save Chart',
                            'button_scheduleshow'                           => 'Show Schedule',
                            'button_schedulehide'                           => 'Hide Schedule',
                            'button_printable'                              => 'Create Printout',
                            'chart_title'                                   => 'Loan Payment Information',
                            'chart_interest'                                => 'Total Interest',
                            'chart_principal'                               => 'Total Principal',
                            'chart_combined'                                => 'Total Payments',
                            'chart_balance'                                 => 'Loan Balance',
                            'schedule_reponsive'                            => 'Table Mode',
                            'schedule_stack'                                => 'Stack',
                            'schedule_swipe'                                => 'Swipe',
                            'schedule_toggle'                               => 'Toggle',
                            'schedule_columns'                              => 'Columns',
                            'schedule_error'                                => 'No eligible columns.',
                            'schedule_sort'                                 => 'Sort Columns',
                            'printable_title'                               => 'Loan Calculator Results',
                            'printable_button'                              => 'Print Page',
                            'single_year'                                   => 'Year',
                            'single_month'                                  => 'Month',
                            'single_day'                                    => 'Day',
                            'plural_year'                                   => 'Years',
                            'plural_month'                                  => 'Months',
                            'plural_day'                                    => 'Days',
                            'not_available'                                 => 'N/A',
                            'period_weekly'                                 => 'Weekly',
                            'period_biweekly'                               => 'Bi-Weekly',
                            'period_semimonthly'                            => 'Semi-Monthly',
                            'period_monthly'                                => 'Monthly',
                            'period_quarterly'                              => 'Quarterly',
                            'period_semiannually'                           => 'Semi-Annually',
                            'period_annually'                               => 'Annually',
                            'payment_date'                                  => 'Date',
                            'payment_interest'                              => 'Interest',
                            'payment_principal'                             => 'Principal',
                            'payment_balance'                               => 'Remaining Balance',
                            'accumulated_principal'                         => 'Accumulated Principal',
                            'accumulated_interest'                          => 'Accumulated Interest',
                            'accumulated_total'                             => 'Accumulated Total',
                            'summary_loanamount'                            => 'Loan Amount:',
                            'summary_loanbalance'                           => 'Remaining Loan Balance:',
                            'summary_datepayout'                            => 'Loan Payout Date:',
                            'summary_datefirst'                             => 'First Payment Date:',
                            'summary_datelast'                              => 'Last Payment Date:',
                            'summary_paymentfirst'                          => 'First Loan Payment:',
                            'summary_paymentlast'                           => 'Last Loan Payment:',
                            'summary_amortization'                          => 'Amortization Term:',
                            'summary_interest'                              => 'Interest Rate:',
                            'summary_frequency'                             => 'Payment Frequency:',
                            'summary_compounding'                           => 'Compounding Method:',
                            'summary_fixedterm'                             => 'Initial Fixed Term:',
                            'summary_fixedpayments'                         => 'Initial Number of Payments:',
                            'summary_totalpayments'                         => 'Total Payments Made:',
                            'summary_totalinterest'                         => 'Total Interest Paid:',
                            'summary_totalprincipal'                        => 'Total Principal Paid:',
                            'notice_startdate'                              => 'For dates greater than the 28th of the month, the date will be changed to 28 to simplify calculations.',
                            'notice_semimonthly'                            => 'For semi-monthly payments, the payment days will be the 1st and the 16th of each month, and the starting date will be the next 1st or 16th. Interest will be calculated based on 24 equal periods per year, regardless of the actual interval between payments.',
                            'notice_insufficient'                           => 'The combination of desired payment amount and interest rate does not cover the first month of interest payments!',
                        ),
                        'plyrmediaplayer'                                   => array(               // $TS_VCSC_PlyrVideo_Language = get_option('ts_vcsc_extend_settings_translationsPlyrPlayer', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Plyr_Player_Language_Defaults);
                            'restart'                                       => 'Restart',
                            'rewind'                                        => 'Rewind {seektime} Secs',
                            'play'                                          => 'Play',
                            'pause'                                         => 'Pause',
                            'forward'                                       => 'Forward {seektime} Secs',
                            'played'                                        => 'Played',
                            'buffered'                                      => 'Buffered',
                            'currenttime'                                   => 'Current Time',
                            'duration'                                      => 'Duration',
                            'volume'                                        => 'Volume',
                            'togglemute'                                    => 'Toggle Mute',
                            'togglecaptions'                                => 'Toggle Captions',
                            'togglefullscreen'                              => 'Toggle Fullscreen',
                            'frametitle'                                    => 'Player for {title}',
                        ),
                        'isotopeposts'                                      => array(               // $TS_VCSC_Isotope_Posts_Language = get_option('ts_vcsc_extend_settings_translationsIsotopePosts', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Isotope_Posts_Language_Defaults);
                            'ButtonFilter'                                  => 'Filter Posts',
                            'ButtonLayout'                                  => 'Change Layout',
                            'ButtonSort'                                    => 'Sort Criteria',
                            'Date'                                          => 'Post Date',
                            'Modified'                                      => 'Post Modified',
                            'Title'                                         => 'Post Title',
                            'Author'                                        => 'Post Author',
                            'PostID'                                        => 'Post ID',
                            'Comments'                                      => 'Number of Comments',
                            'SeeAll'                                        => 'See All',
                            'Timeline'                                      => 'Timeline',
                            'Masonry'                                       => 'Centered Masonry',
                            'FitRows'                                       => 'Fit Rows',
                            'StraightDown'                                  => 'Straigt Down',
                            'WooFilterProducts'                             => 'Filter Products',
                            'WooTitle'                                      => 'Product Title',
                            'WooPrice'                                      => 'Product Price',
                            'WooRating'                                     => 'Product Rating',
                            'WooDate'                                       => 'Product Date',
                            'WooModified'                                   => 'Product Modified',
                            'Categories'                                    => 'Categories',
                            'Tags'                                          => 'Tags',
                        ),
                    ),
                    // External Files
                    'externalfiles'                                     => array(
                        'forceloadjquery'                                   => false,                 // $ts_vcsc_extend_settings_loadjQuery = get_option('ts_vcsc_extend_settings_loadjQuery', 0);
                        'forceloadcore'                                     => false,                 // $ts_vcsc_extend_settings_loadForcable = get_option('ts_vcsc_extend_settings_loadForcable', 0);
                        'forceloadhead'                                     => false,                 // $ts_vcsc_extend_settings_loadHeader = get_option('ts_vcsc_extend_settings_loadHeader', 0);
                        'forceloadstandard'                                 => true,                  // $ts_vcsc_extend_settings_loadEnqueue = get_option('ts_vcsc_extend_settings_loadEnqueue', 1);
                        'alwaysloadlightbox'                                => false,                 // $ts_vcsc_extend_settings_loadLightbox = get_option('ts_vcsc_extend_settings_loadLightbox', 0);
                        'alwaysloadtooltips'                                => false,                 // $ts_vcsc_extend_settings_loadTooltip = get_option('ts_vcsc_extend_settings_loadTooltip', 0);
                        'alwaysloadiconfonts'                               => false,                 // $ts_vcsc_extend_settings_loadFonts = get_option('ts_vcsc_extend_settings_loadFonts', 0);                        
                        'loadhammertwo'                                     => true,                  // $ts_vcsc_extend_settings_loadHammerNew = get_option('ts_vcsc_extend_settings_loadHammerNew', 1);
                        'loadmagnific'                                      => true,                  // $ts_vcsc_extend_settings_loadMagnific = get_option('ts_vcsc_extend_settings_loadMagnific', 1);
                        'loadwaypoints'                                     => true,                  // $ts_vcsc_extend_settings_loadWaypoints = get_option('ts_vcsc_extend_settings_loadWaypoints', 1);
                        'loadmootools'                                      => true,                  // $ts_vcsc_extend_settings_loadMooTools = get_option('ts_vcsc_extend_settings_loadMooTools', 1);
                        'loaddetector'                                      => true,                  // $ts_vcsc_extend_settings_loadDetector = get_option('ts_vcsc_extend_settings_loadDetector', 1);
                    ),
                    // Social Networks
                    'socialnetworks'                                    => array(
                        "Email"                                             => array("order" => 0,      "string" => "email",        "link" => "",       "class" => "ts-social-email",           "icon" => "ts-teamicon-email3"),
                        "Phone"                                             => array("order" => 1,      "string" => "phone",        "link" => "",       "class" => "ts-social-phone",           "icon" => "ts-teamicon-phone2"),
                        "Cell"                                              => array("order" => 2,      "string" => "cell",         "link" => "",       "class" => "ts-social-cell",            "icon" => "ts-teamicon-mobile"),
                        "Portfolio"                                         => array("order" => 3,      "string" => "portfolio",    "link" => "",       "class" => "ts-social-portfolio",       "icon" => "ts-teamicon-portfolio"),
                        "Link"                                              => array("order" => 4,      "string" => "link",         "link" => "",       "class" => "ts-social-link",            "icon" => "ts-teamicon-link"),
                        "Behance"                                           => array("order" => 5,      "string" => "behance",      "link" => "",       "class" => "ts-social-behance",         "icon" => "ts-teamicon-behance"),
                        "Digg"                                              => array("order" => 6,      "string" => "digg",         "link" => "",       "class" => "ts-social-digg",            "icon" => "ts-teamicon-digg1"),
                        "Dribbble"                                          => array("order" => 7,      "string" => "dribbble",     "link" => "",       "class" => "ts-social-dribbble",        "icon" => "ts-teamicon-dribbble1"),
                        "Dropbox"                                           => array("order" => 8,      "string" => "dropbox",      "link" => "",       "class" => "ts-social-dropbox",         "icon" => "ts-teamicon-dropbox1"),
                        "Envato"                                            => array("order" => 9,      "string" => "envato",       "link" => "",       "class" => "ts-social-envato",          "icon" => "ts-teamicon-envato"),
                        "EverNote"                                          => array("order" => 10,     "string" => "evernote",     "link" => "",       "class" => "ts-social-evernote",        "icon" => "ts-teamicon-evernote1"),
                        "Facebook"                                          => array("order" => 11,     "string" => "facebook",     "link" => "",       "class" => "ts-social-facebook",        "icon" => "ts-teamicon-facebook3"),
                        "Flickr"                                            => array("order" => 12,     "string" => "flickr",       "link" => "",       "class" => "ts-social-flickr",          "icon" => "ts-teamicon-flickr4"),
                        "Github"                                            => array("order" => 13,     "string" => "github",       "link" => "",       "class" => "ts-social-github",          "icon" => "ts-teamicon-github3"),
                        "Google"                                            => array("order" => 14,     "string" => "gplus",        "link" => "",       "class" => "ts-social-gplus",           "icon" => "ts-teamicon-googleplus1"),
                        "Instagram"                                         => array("order" => 15,     "string" => "instagram",    "link" => "",       "class" => "ts-social-instagram",       "icon" => "ts-teamicon-instagram"),
                        "LastFM"                                            => array("order" => 16,     "string" => "lastfm",       "link" => "",       "class" => "ts-social-lastfm",          "icon" => "ts-teamicon-lastfm2"),
                        "LinkedIn"                                          => array("order" => 17,     "string" => "linkedin",     "link" => "",       "class" => "ts-social-linkedin",        "icon" => "ts-teamicon-linkedin1"),
                        "Paypal"                                            => array("order" => 18,     "string" => "paypal",       "link" => "",       "class" => "ts-social-paypal",          "icon" => "ts-teamicon-paypal1"),
                        "Picasa"                                            => array("order" => 19,     "string" => "picasa",       "link" => "",       "class" => "ts-social-picasa",          "icon" => "ts-teamicon-picasa1"),
                        "Pinterest"                                         => array("order" => 20,     "string" => "pinterest",    "link" => "",       "class" => "ts-social-pinterest",       "icon" => "ts-teamicon-pinterest1"),
                        "RSS"                                               => array("order" => 21,     "string" => "rss",          "link" => "",       "class" => "ts-social-rss",             "icon" => "ts-teamicon-rss1"),
                        "Skype"                                             => array("order" => 22,     "string" => "skype",        "link" => "",       "class" => "ts-social-skype",           "icon" => "ts-teamicon-skype"),
                        "Soundcloud"                                        => array("order" => 23,     "string" => "soundcloud",   "link" => "",       "class" => "ts-social-soundcloud",      "icon" => "ts-teamicon-soundcloud"),
                        "Spotify"                                           => array("order" => 24,     "string" => "spotify",      "link" => "",       "class" => "ts-social-spotify",         "icon" => "ts-teamicon-spotify2"),
                        "StumbleUpon"                                       => array("order" => 25,     "string" => "stumbleupon",  "link" => "",       "class" => "ts-social-stumbleupon",     "icon" => "ts-teamicon-stumbleupon2"),
                        "Twitter"                                           => array("order" => 26,     "string" => "twitter",      "link" => "",       "class" => "ts-social-twitter",         "icon" => "ts-teamicon-twitter4"),
                        "Tumblr"                                            => array("order" => 27,     "string" => "tumblr",       "link" => "",       "class" => "ts-social-tumblr",          "icon" => "ts-teamicon-tumblr4"),
                        "Vimeo"                                             => array("order" => 28,     "string" => "vimeo",        "link" => "",       "class" => "ts-social-vimeo",           "icon" => "ts-teamicon-vimeo1"),
                        "VKontakte"                                         => array("order" => 29,     "string" => "vkontakte",    "link" => "",       "class" => "ts-social-vkontakte",       "icon" => "ts-teamicon-vkontakte"),
                        "Wikipedia"                                         => array("order" => 30,     "string" => "wikipedia",    "link" => "",       "class" => "ts-social-wikipedia",       "icon" => "ts-teamicon-wikipedia"),
                        "Xing"                                              => array("order" => 31,     "string" => "xing",         "link" => "",       "class" => "ts-social-xing",            "icon" => "ts-teamicon-xing3"),
                        "YouTube"                                           => array("order" => 32,     "string" => "youtube",      "link" => "",       "class" => "ts-social-youtube",         "icon" => "ts-teamicon-youtube4"),
                    ),
                    // WordPress Release Specific Fixes
                    'wordpressfixes'                                    => array(
                        'fixjquerymigrate'                                  => false,                  // $ts_vcsc_extend_settings_useFixjQueryMigrate = get_option('ts_vcsc_extend_settings_useFixjQueryMigrate', 1);
                        'fixcolorpickerl10n'                                => false,                  // $ts_vcsc_extend_settings_useFixColorPickerL10n = get_option('ts_vcsc_extend_settings_useFixColorPickerL10n', 1);
                    ),
                    // Migration Markers
                    'migrationmarkers'                                  => array(
                        'migratesettings'                                   => false,
                    ),
                );
            }

            function TS_Settings_Inputs() {
                $this->TS_VCSC_Settings_Inputs                                  = array(
                    // General Settings
                    'general'                                           => array(
                        'useextendedsettings'                               => "ts_vcsc_extend_settings_allowFullOptions",
                        'useautoupdate'                                     => "ts_vcsc_extend_settings_allowAutoUpdate",
                        'useownmenuentry'                                   => "ts_vcsc_extend_settings_mainmenu",
                        'uselanguagedomain'                                 => "ts_vcsc_extend_settings_translationsDomain",
                        'usedashboardpanel'                                 => "ts_vcsc_extend_settings_dashboard",
                        'useiconicumgenerator'                              => array(
                            'iconmenugenerator'                                 => "ts_vcsc_extend_settings_useMenuGenerator",
                            'icontinymcegenerator'                              => "ts_vcsc_extend_settings_useIconGenerator",
                            'icontinymceposttypes'                              => "ts_vcsc_extend_settings_usePostTypes",
                        ),
                        'usevariablespriority'                              => "ts_vcsc_extend_settings_variablesPriority",
                        'shortcodesinwidgets'                               => "ts_vcsc_extend_settings_allowShortcodesWidgets",
                        'shortcodesinbackend'                               => "ts_vcsc_extend_settings_shortcodesalways",
                        'managergooglefonts'                                => "ts_vcsc_extend_settings_allowGoogleManager",
                        'managercustomfonts'                                => "ts_vcsc_extend_settings_allowCustomManager",
                        'managerdowntime'                                   => "ts_vcsc_extend_settings_allowDowntimeManager",
                        'managersidebars'                                   => "ts_vcsc_extend_settings_allowSidebarsManager",
                        'allowautoparagraph'                                => "ts_vcsc_extend_settings_allowAutoParagraphs",
                        'allowsanitizecontent'                              => "ts_vcsc_extend_settings_sanitizeContent",
                        'allowsanitizescope'                                => "ts_vcsc_extend_settings_sanitizeScope", 
                    ),
                    // WP Bakery PAge Builder: Elements
                    'pagebuildermainelements'                           => array(
                        'elementsstandard'                                  => "",
                        'elementsdeveloper'                                 => "",
                        'elementswoocommerce'                               => "",
                        'elementsbbpress'                                   => "",
                        'elementsthirdparties'                              => "",
                        'elementsdeprecated'                                => array(
                            'deprecatedelements'                            => "",
                            'deprecatedselector'                            => "ts_vcsc_extend_settings_allowDeprecated",
                        ),
                        'elementspagenavigator'                             => "ts_vcsc_extend_settings_allowPageNavigator",
                        'elementssyntaxhighlighter'                         => array(
                            'syntaxhighlighteruse'                              => "ts_vcsc_extend_settings_allowEnlighterJS",
                            'syntaxhighlightertheme'                            => "ts_vcsc_extend_settings_allowThemeBuilder",
                        ),
                    ),
                    // WP Bakery Page Builder: Sections, Rows, Columns
                    'pagebuilderstructure'                              => array(
                        'rowsadditions'                                     => array(
                            'useadditionsrows'                                  => "ts_vcsc_extend_settings_additionsRows",
                            'usebackgroundindicator'                            => "ts_vcsc_extend_settings_backgroundIndicator",
                            'usebreakpoint'                                     => "ts_vcsc_extend_settings_additionsRowEffectsBreak",
                            'useoffset'                                         => "ts_vcsc_extend_settings_additionsOffsets",
                            'usevisibility'                                     => array(
                                'Large Devices'                                     => "ts_vcsc_extend_settings_rowLimitLarge",
                                'Medium Devices'                                    => "ts_vcsc_extend_settings_rowLimitMedium",
                                'Small Devices'                                     => "ts_vcsc_extend_settings_rowLimitSmall",
                            ),
                        ),
                        'rowscustomizer'                                    => array(
                            "globals"                                           => "ts_vcsc_extend_settings_rowAllowableGlobalsValue",
                            "backgrounds"                                       => "ts_vcsc_extend_settings_rowAllowableBackgroundsValue",
                            "effects"                                           => "ts_vcsc_extend_settings_rowAllowableEffectsValue",
                        ),
                        'columnsadditions'                                  => "ts_vcsc_extend_settings_additionsColumns",
                        'usesmoothscroll'                                   => "ts_vcsc_extend_settings_additionsSmoothScroll",
                    ),
                    // WP Bakery Page Builder: Other Additions
                    'pagebuilderother'                                  => array(
                        'usecontainertoggle'                                => "ts_vcsc_extend_settings_containerToggle",
                        'useelementfilter'                                  => "ts_vcsc_extend_settings_elementFilter",
                        'useextendednesting'                                => "ts_vcsc_extend_settings_allowExtendedNesting",
                        'useshortcodeviewer'                                => "ts_vcsc_extend_settings_allowShortcodeViewer",
                        'useimagepreview'                                   => "ts_vcsc_extend_settings_previewImages",
                        'usebackendpreview'                                 => "ts_vcsc_extend_settings_backendPreview",
                        'usefrontendeditor'                                 => "ts_vcsc_extend_settings_frontendEditor",
                        'usewpautoparagraph'                                => "ts_vcsc_extend_settings_allowWPBBuilderWPAutoP",
                        'usetinymceencoded'                                 => "ts_vcsc_extend_settings_tinymceEncoded",
                        'usevisualiconpicker'                               => array(
                            'iconpickerutilize'                                 => "ts_vcsc_extend_settings_visualSelector",
                            'iconpickerpagination'                              => "ts_vcsc_extend_settings_nativePaginator",
                        ),
                        'usevisuallinkpicker'                               => array(
                            'enabled'                                           => "ts_vcsc_extend_settings_linkerEnabled",
                            'global'                                            => "ts_vcsc_extend_settings_linkerGlobal",
                            'offset'                                            => "ts_vcsc_extend_settings_linkerOffset",
                            'posts'                                             => "ts_vcsc_extend_settings_linkerPosts",
                            'custom'                                            => "ts_vcsc_extend_settings_linkerCustom",
                            'orderby'                                           => "ts_vcsc_extend_settings_linkerOrderby",
                            'order'                                             => "ts_vcsc_extend_settings_linkerOrder",
                        ),
                        'usenvisualouislider'                               => array(
                            'enabled'                                           => "ts_vcsc_extend_settings_nouisliderEnabled",
                            'pips'                                              => "ts_vcsc_extend_settings_nouisliderPips",
                            'tooltip'                                           => "ts_vcsc_extend_settings_nouisliderTooltip",
                            'input'                                             => "ts_vcsc_extend_settings_nouisliderInput",
                        ),
                    ),
                    // WP Bakery Page Builder: Icon Fonts
                    'pagebuildericonfonts'                              => array(
                        'active'                                            => "",
                        'alwaysload'                                        => "",
                    ),
                    // Custom Icon Fonts
                    'customiconfonts'                                   => array(
                        'active'                                            => "",
                        'alwaysload'                                        => "",
                    ),
                    // Built-In Kraut Lightbox
                    'krautlightbox'                                     => array(
                        'usekrautlightbox'                                  => "ts_vcsc_extend_settings_builtinLightbox",
                        'usetinymceintegration'                             => "ts_vcsc_extend_settings_lightboxIntegration",
                        'useprettyphotooverride'                            => "ts_vcsc_extend_settings_lightboxPrettyPhoto",
                        'useattachallothermedia'                            => "ts_vcsc_extend_settings_lightboxAttachAllOther",
                        'uselightboxinternals'                              => array(
                            'thumbs'                                            => "ts_vcsc_extend_settings_defaultLightboxThumbs",
                            'thumbsize'                                         => "ts_vcsc_extend_settings_defaultLightboxThumbSize",
                            'animation'                                         => "ts_vcsc_extend_settings_defaultLightboxAnimation",
                            'captions'                                          => "ts_vcsc_extend_settings_defaultLightboxCaptions",
                            'closer'                                            => "ts_vcsc_extend_settings_defaultLightboxCloser",
                            'duration'                                          => "ts_vcsc_extend_settings_defaultLightboxDuration",
                            'save'                                              => "ts_vcsc_extend_settings_defaultLightboxSave",
                            'share'                                             => "ts_vcsc_extend_settings_defaultLightboxShare",
                            'loadapis'                                          => "ts_vcsc_extend_settings_defaultLightboxLoadAPIs",
                            'social'                                            => "ts_vcsc_extend_settings_defaultLightboxSocial",
                            'notouch'                                           => "ts_vcsc_extend_settings_defaultLightboxNoTouch",
                            'bgclose'                                           => "ts_vcsc_extend_settings_defaultLightboxBGClose",
                            'nohashes'                                          => "ts_vcsc_extend_settings_defaultLightboxHashtag",
                            'keyboard'                                          => "ts_vcsc_extend_settings_defaultLightboxKeyboard",
                            'fullscreen'                                        => "ts_vcsc_extend_settings_defaultLightboxFullScreen",
                            'zoom'                                              => "ts_vcsc_extend_settings_defaultLightboxZoom",
                            'fxspeed'                                           => "ts_vcsc_extend_settings_defaultLightboxSpeedFX",
                            'scheme'                                            => "ts_vcsc_extend_settings_defaultLightboxScheme",
                            'controls'                                          => "ts_vcsc_extend_settings_defaultLightboxControls",
                            'removelight'                                       => "ts_vcsc_extend_settings_defaultLightboxRemoveLight",
                            'customlight'                                       => "ts_vcsc_extend_settings_defaultLightboxCustomLight",
                            'customcolor'                                       => "ts_vcsc_extend_settings_defaultLightboxCustomColor",
                            'backlight'                                         => "ts_vcsc_extend_settings_defaultLightboxBacklight",
                            'usecolor'                                          => "ts_vcsc_extend_settings_defaultLightboxUseColor",
                            'urlcolorscan'                                      => "ts_vcsc_extend_settings_defaultLightboxURLScan",
                            'background'                                        => "ts_vcsc_extend_settings_defaultLightboxBackground",
                            'repeat'                                            => "ts_vcsc_extend_settings_defaultLightboxRepeat",
                            'overlay'                                           => "ts_vcsc_extend_settings_defaultLightboxOverlay",
                            'noise'                                             => "ts_vcsc_extend_settings_defaultLightboxNoise",
                            'cors'                                              => "ts_vcsc_extend_settings_defaultLightboxCors",
                            'tapping'                                           => "ts_vcsc_extend_settings_defaultLightboxTapping",
                            'scrollblock'                                       => "ts_vcsc_extend_settings_defaultLightboxScrollBlock",
                            'protection'                                        => "ts_vcsc_extend_settings_defaultLightboxProtection",
                            'historyclose'                                      => "ts_vcsc_extend_settings_defaultLightboxHistoryClose",
                            'customscroll'                                      => "ts_vcsc_extend_settings_defaultLightboxCustomScroll",
                        )
                    ),
                    // Custom Post Types
                    'posttypes'                                         => array(
                        'postwidgets'                                       => "ts_vcsc_extend_settings_customWidgets",
                        'postteams'                                         => "ts_vcsc_extend_settings_customTeam",
                        'posttestimonials'                                  => "ts_vcsc_extend_settings_customTestimonial",
                        'postskillsets'                                     => "ts_vcsc_extend_settings_customSkillset",
                        'posttimelines'                                     => "ts_vcsc_extend_settings_customTimelines",
                        'postlogos'                                         => "ts_vcsc_extend_settings_customLogo",
                        'postlayers'                                        => "ts_vcsc_extend_settings_customLayers",
                        'postsautoassignment'                               => "ts_vcsc_extend_settings_allowAutoAssignment",
                        'postpositions'                                     => array(
                            'ts_widgets'                                        => "ts_vcsc_extend_settings_positionWidgets",
                            'ts_timeline'                                       => "ts_vcsc_extend_settings_positionTimeline",
                            'ts_team'                                           => "ts_vcsc_extend_settings_positionTeam",
                            'ts_testimonials'                                   => "ts_vcsc_extend_settings_positionTestimonials",
                            'ts_skillsets'                                      => "ts_vcsc_extend_settings_positionSkillsets",
                            'ts_logos'                                          => "ts_vcsc_extend_settings_positionLogos",
                            'ts_layers'                                         => "ts_vcsc_extend_settings_positionLayers",
                            'ts_downtime'                                       => "ts_vcsc_extend_settings_positionDowntime",
                        ),
                    ),
                    // External API's
                    'externalapis'                                      => array(
                        'apigooglemaps'                                     => "ts_vcsc_extend_settings_externalAPIGoogleMaps",
                        'apiyoutube'                                        => "ts_vcsc_extend_settings_externalAPIYouTube",
                    ),
                    // Language Strings
                    'languagestrings'                                   => array(
                        'googlemapsold'                                     => array(
                            'TextCalcShow'                                  => "ts_vcsc_extend_settings_languageTextCalcShow",
                            'TextCalcHide'                                  => "ts_vcsc_extend_settings_languageTextCalcHide",
                            'TextDirectionShow'                             => "ts_vcsc_extend_settings_languageTextDirectionShow",
                            'TextDirectionHide'                             => "ts_vcsc_extend_settings_languageTextDirectionHide",
                            'TextResetMap'                                  => "ts_vcsc_extend_settings_languageTextResetMap",
                            'PrintRouteText' 			                    => "ts_vcsc_extend_settings_languagePrintRouteText",
                            'TextViewOnGoogle'                              => "ts_vcsc_extend_settings_languageTextViewOnGoogle",
                            'TextButtonCalc'                                => "ts_vcsc_extend_settings_languageTextButtonCalc",
                            'TextSetTarget'                                 => "ts_vcsc_extend_settings_languageTextSetTarget",
                            'TextGeoLocation'                               => "ts_vcsc_extend_settings_languageTextGeoLocation",
                            'TextTravelMode'                                => "ts_vcsc_extend_settings_languageTextTravelMode",
                            'TextDriving'                                   => "ts_vcsc_extend_settings_languageTextDriving",
                            'TextWalking'                                   => "ts_vcsc_extend_settings_languageTextWalking",
                            'TextBicy'                                      => "ts_vcsc_extend_settings_languageTextBicy",
                            'TextWP'                                        => "ts_vcsc_extend_settings_languageTextWP",
                            'TextButtonAdd'                                 => "ts_vcsc_extend_settings_languageTextButtonAdd",
                            'TextDistance'                                  => "ts_vcsc_extend_settings_languageTextDistance",
                            'TextMapHome'                                   => "ts_vcsc_extend_settings_languageTextMapHome",
                            'TextMapBikes'                                  => "ts_vcsc_extend_settings_languageTextMapBikes",
                            'TextMapTraffic'                                => "ts_vcsc_extend_settings_languageTextMapTraffic",
                            'TextMapSpeedMiles'                             => "ts_vcsc_extend_settings_languageTextMapSpeedMiles",
                            'TextMapSpeedKM'                                => "ts_vcsc_extend_settings_languageTextMapSpeedKM",
                            'TextMapNoData'                                 => "ts_vcsc_extend_settings_languageTextMapNoData",
                            'TextMapMiles'                                  => "ts_vcsc_extend_settings_languageTextMapMiles",
                            'TextMapKilometes'                              => "ts_vcsc_extend_settings_languageTextMapKilometes",
                            'TextMapActivate'                               => "ts_vcsc_extend_settings_languageTextMapActivate",
                            'TextMapDeactivate'                             => "ts_vcsc_extend_settings_languageTextMapDeactivate",
                        ),
                        'googlemapsplus'                                    => array(
                            'ListenersStart'                                => "ts_vcsc_extend_settings_languageTextListenersStart",
                            'ListenersStop'                                 => "ts_vcsc_extend_settings_languageTextListenersStop",
                            'MobileShow'                                    => "ts_vcsc_extend_settings_languageTextMobileShow",
                            'MobileHide'                                    => "ts_vcsc_extend_settings_languageTextMobileHide",
                            'StyleDefault'                                  => "ts_vcsc_extend_settings_languageTextStyleDefault",
                            'StyleLabel'                                    => "ts_vcsc_extend_settings_languageTextStyleLabel",
                            'FilterAll'                                     => "ts_vcsc_extend_settings_languageTextFilterAll",
                            'FilterLabel'                                   => "ts_vcsc_extend_settings_languageTextFilterLabel",
                            'SelectLabel'                                   => "ts_vcsc_extend_settings_languageTextSelectLabel",
                            'ControlsOSM'                                   => "ts_vcsc_extend_settings_languageTextControlsOSM",
                            'ControlsHome'                                  => "ts_vcsc_extend_settings_languageTextControlsHome",
                            'ControlsBounds'                                => "ts_vcsc_extend_settings_languageTextControlsBounds",
                            'ControlsBike'                                  => "ts_vcsc_extend_settings_languageTextControlsBike",
                            'ControlsTraffic'                               => "ts_vcsc_extend_settings_languageTextControlsTraffic",
                            'ControlsTransit'                               => "ts_vcsc_extend_settings_languageTextControlsTransit",
                            'TrafficMiles'                                  => "ts_vcsc_extend_settings_languageTextTrafficMiles",
                            'TrafficKilometer'                              => "ts_vcsc_extend_settings_languageTextTrafficKilometer",
                            'TrafficNone'                                   => "ts_vcsc_extend_settings_languageTextTrafficNone",
                            'SearchButton'                                  => "ts_vcsc_extend_settings_languageTextSearchButton",
                            'SearchHolder'                                  => "ts_vcsc_extend_settings_languageTextSearchHolder",
                            'SearchGoogle'                                  => "ts_vcsc_extend_settings_languageTextSearchGoogle",
                            'SearchDirections'                              => "ts_vcsc_extend_settings_languageTextSearchDirections",
                            'SearchGroup'                                   => "ts_vcsc_extend_settings_languageTextSearchGroup",
                            'OtherLink'                                     => "ts_vcsc_extend_settings_languageTextOtherLink",
                            'PlaceholderMarker'                             => "ts_vcsc_extend_settings_languageTextPlaceholderMarker",
                            'ListingsButton'                                => "ts_vcsc_extend_settings_languageTextListingsButton",
                            'ListingsSearch'                                => "ts_vcsc_extend_settings_languageTextListingsSearch",
                            'SumoConfirm'                                   => "ts_vcsc_extend_settings_languageTextSumoConfirm",
                            'SumoCancel'                                    => "ts_vcsc_extend_settings_languageTextSumoCancel",
                            'SumoSelected'                                  => "ts_vcsc_extend_settings_languageTextSumoSelected",
                            'SumoAllSelected'                               => "ts_vcsc_extend_settings_languageTextSumoAllSelected",
                            'SumoPlaceholder'                               => "ts_vcsc_extend_settings_languageTextSumoPlaceholder",
                            'SumoSearchLocations'                           => "ts_vcsc_extend_settings_languageTextSumoSearchLocations",
                            'SumoSearchGroups'                              => "ts_vcsc_extend_settings_languageTextSumoSearchGroups",
                            'SumoSearchStyles'                              => "ts_vcsc_extend_settings_languageTextSumoSearchStyles",
                        ),
                        'countdown'                                         => array(
                            'DayPlural'                                     => "ts_vcsc_extend_settings_languageDayPlural",
                            'DaySingular'                                   => "ts_vcsc_extend_settings_languageDaySingular",
                            'HourPlural'                                    => "ts_vcsc_extend_settings_languageHourPlural",
                            'HourSingular'                                  => "ts_vcsc_extend_settings_languageHourSingular",
                            'MinutePlural'                                  => "ts_vcsc_extend_settings_languageMinutePlural",
                            'MinuteSingular'                                => "ts_vcsc_extend_settings_languageMinuteSingular",
                            'SecondPlural'                                  => "ts_vcsc_extend_settings_languageSecondPlural",
                            'SecondSingular'                                => "ts_vcsc_extend_settings_languageSecondSingular",
                        ),
                        'imagemagnify'                                      => array(
                            'ZoomIn'                                        => "ts_vcsc_extend_settings_languageMagnifyZoomIn",
                            'ZoomOut'                                       => "ts_vcsc_extend_settings_languageMagnifyZoomOut",
                            'ZoomLevel'                                     => "ts_vcsc_extend_settings_languageMagnifyZoomLevel",
                            'ChangeLevel'                                   => "ts_vcsc_extend_settings_languageMagnifyChangeLevel",
                            'Next'                                          => "ts_vcsc_extend_settings_languageMagnifyNext",
                            'Previous'                                      => "ts_vcsc_extend_settings_languageMagnifyPrevious",
                            'Reset'                                         => "ts_vcsc_extend_settings_languageMagnifyReset",
                            'Rotate'                                        => "ts_vcsc_extend_settings_languageMagnifyRotate",
                            'Lightbox'                                      => "ts_vcsc_extend_settings_languageMagnifyLightbox",
                        ),
                        'loancalculator'                                    => array(
                            'settings_title'                                => "ts_vcsc_extend_settings_languageLoanCalculatorSettingsTitle",
                            'settings_results'                              => "ts_vcsc_extend_settings_languageLoanCalculatorSettingsResults",
                            'baseline_message'                              => "ts_vcsc_extend_settings_languageLoanCalculatorBaselineMessage",
                            'baseline_payment'                              => "ts_vcsc_extend_settings_languageLoanCalculatorBaselinePayment",
                            'baseline_term'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorBaselineTerm",
                            'baseline_principal'                            => "ts_vcsc_extend_settings_languageLoanCalculatorBaselinePrincipal",
                            'principal_label'                               => "ts_vcsc_extend_settings_languageLoanCalculatorPrincipalLabel",
                            'principal_error'                               => "ts_vcsc_extend_settings_languageLoanCalculatorPrincipalError",
                            'interest_label'                                => "ts_vcsc_extend_settings_languageLoanCalculatorInterestLabel",
                            'interest_error'                                => "ts_vcsc_extend_settings_languageLoanCalculatorInterestError",
                            'years_label'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorYearsLabel",
                            'years_error'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorYearsError",
                            'payment_label'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorPaymentLabel",
                            'payment_error'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorPaymentError",
                            'fixed_label'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorFixedLabel",
                            'fixed_match'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorFixedMatch",
                            'frequency_label'                               => "ts_vcsc_extend_settings_languageLoanCalculatorFrequencyLabel",
                            'compounding_label'                             => "ts_vcsc_extend_settings_languageLoanCalculatorCompoundingLabel",
                            'compounding_simple'                            => "ts_vcsc_extend_settings_languageLoanCalculatorCompoundingSimple",
                            'compounding_monthly'                           => "ts_vcsc_extend_settings_languageLoanCalculatorCompoundingMonthly",
                            'compounding_quarter'                           => "ts_vcsc_extend_settings_languageLoanCalculatorCompoundingQuarter",
                            'compounding_semi'                              => "ts_vcsc_extend_settings_languageLoanCalculatorCompoundingSemi",
                            'compounding_annual'                            => "ts_vcsc_extend_settings_languageLoanCalculatorCompoundingAnnual",
                            'origination_label'                             => "ts_vcsc_extend_settings_languageLoanCalculatorOriginationLabel",
                            'origination_error'                             => "ts_vcsc_extend_settings_languageLoanCalculatorOriginationError",
                            'disclaimer_message'                            => "ts_vcsc_extend_settings_languageLoanCalculatorDisclaimerMessage",
                            'button_calculate'                              => "ts_vcsc_extend_settings_languageLoanCalculatorButtonCalculate",
                            'button_reset'                                  => "ts_vcsc_extend_settings_languageLoanCalculatorButtonReset",
                            'button_chartshow'                              => "ts_vcsc_extend_settings_languageLoanCalculatorButtonChartshow",
                            'button_charthide'                              => "ts_vcsc_extend_settings_languageLoanCalculatorButtonCharthide",
                            'button_chartsave'                              => "ts_vcsc_extend_settings_languageLoanCalculatorButtonChartsave",
                            'button_scheduleshow'                           => "ts_vcsc_extend_settings_languageLoanCalculatorButtonScheduleshow",
                            'button_schedulehide'                           => "ts_vcsc_extend_settings_languageLoanCalculatorButtonSchedulehide",
                            'button_printable'                              => "ts_vcsc_extend_settings_languageLoanCalculatorButtonPrintable",
                            'chart_title'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorChartTitle",
                            'chart_interest'                                => "ts_vcsc_extend_settings_languageLoanCalculatorChartInterest",
                            'chart_principal'                               => "ts_vcsc_extend_settings_languageLoanCalculatorChartPrincipal",
                            'chart_combined'                                => "ts_vcsc_extend_settings_languageLoanCalculatorChartCombined",
                            'chart_balance'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorChartBalance",
                            'schedule_reponsive'                            => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleReponsive",
                            'schedule_stack'                                => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleStack",
                            'schedule_swipe'                                => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleSwipe",
                            'schedule_toggle'                               => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleToggle",
                            'schedule_columns'                              => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleColumns",
                            'schedule_error'                                => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleError",
                            'schedule_sort'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorScheduleSort",
                            'printable_title'                               => "ts_vcsc_extend_settings_languageLoanCalculatorPrintableTitle",
                            'printable_button'                              => "ts_vcsc_extend_settings_languageLoanCalculatorPrintableButton",
                            'single_year'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorSingleYear",
                            'single_month'                                  => "ts_vcsc_extend_settings_languageLoanCalculatorSingleMonth",
                            'single_day'                                    => "ts_vcsc_extend_settings_languageLoanCalculatorSingleDay",
                            'plural_year'                                   => "ts_vcsc_extend_settings_languageLoanCalculatorPluralYear",
                            'plural_month'                                  => "ts_vcsc_extend_settings_languageLoanCalculatorPluralMonth",
                            'plural_day'                                    => "ts_vcsc_extend_settings_languageLoanCalculatorPluralDay",
                            'not_available'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorNotAvailable",
                            'period_weekly'                                 => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodWeekly",
                            'period_biweekly'                               => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodBiweekly",
                            'period_semimonthly'                            => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodSemimonthly",
                            'period_monthly'                                => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodMonthly",
                            'period_quarterly'                              => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodQuarterly",
                            'period_semiannually'                           => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodSemiannually",
                            'period_annually'                               => "ts_vcsc_extend_settings_languageLoanCalculatorPeriodAnnually",
                            'payment_date'                                  => "ts_vcsc_extend_settings_languageLoanCalculatorPaymentDate",
                            'payment_interest'                              => "ts_vcsc_extend_settings_languageLoanCalculatorPaymentInterest",
                            'payment_principal'                             => "ts_vcsc_extend_settings_languageLoanCalculatorPaymentPrincipal",
                            'payment_balance'                               => "ts_vcsc_extend_settings_languageLoanCalculatorPaymentBalance",
                            'accumulated_principal'                         => "ts_vcsc_extend_settings_languageLoanCalculatorAccumulatedPrincipal",
                            'accumulated_interest'                          => "ts_vcsc_extend_settings_languageLoanCalculatorAccumulatedInterest",
                            'accumulated_total'                             => "ts_vcsc_extend_settings_languageLoanCalculatorAccumulatedTotal",
                            'summary_loanamount'                            => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryLoanamount",
                            'summary_loanbalance'                           => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryLoanbalance",
                            'summary_datepayout'                            => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryDatepayout",
                            'summary_datefirst'                             => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryDatefirst",
                            'summary_datelast'                              => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryDatelast",
                            'summary_paymentfirst'                          => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryPaymentfirst",
                            'summary_paymentlast'                           => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryPaymentlast",
                            'summary_amortization'                          => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryAmortization",
                            'summary_interest'                              => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryInterest",
                            'summary_frequency'                             => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryFrequency",
                            'summary_compounding'                           => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryCompounding",
                            'summary_fixedterm'                             => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryFixedterm",
                            'summary_fixedpayments'                         => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryFixedpayments",
                            'summary_totalpayments'                         => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryTotalpayments",
                            'summary_totalinterest'                         => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryTotalinterest",
                            'summary_totalprincipal'                        => "ts_vcsc_extend_settings_languageLoanCalculatorSummaryTotalprincipal",
                            'notice_startdate'                              => "ts_vcsc_extend_settings_languageLoanCalculatorNoticeStartdate",
                            'notice_semimonthly'                            => "ts_vcsc_extend_settings_languageLoanCalculatorNoticeSemimonthly",
                            'notice_insufficient'                           => "ts_vcsc_extend_settings_languageLoanCalculatorNoticeInsufficient",
                        ),
                        'plyrmediaplayer'                                   => array(
                            'restart'                                       => "ts_vcsc_extend_settings_languagePlyrPlayerRestart",
                            'rewind'                                        => "ts_vcsc_extend_settings_languagePlyrPlayerRewind",
                            'play'                                          => "ts_vcsc_extend_settings_languagePlyrPlayerPlay",
                            'pause'                                         => "ts_vcsc_extend_settings_languagePlyrPlayerPause",
                            'forward'                                       => "ts_vcsc_extend_settings_languagePlyrPlayerForward",
                            'played'                                        => "ts_vcsc_extend_settings_languagePlyrPlayerPlayed",
                            'buffered'                                      => "ts_vcsc_extend_settings_languagePlyrPlayerBuffered",
                            'currenttime'                                   => "ts_vcsc_extend_settings_languagePlyrPlayerCurrenttime",
                            'duration'                                      => "ts_vcsc_extend_settings_languagePlyrPlayerDuration",
                            'volume'                                        => "ts_vcsc_extend_settings_languagePlyrPlayerVolume",
                            'togglemute'                                    => "ts_vcsc_extend_settings_languagePlyrPlayerTogglemute",
                            'togglecaptions'                                => "ts_vcsc_extend_settings_languagePlyrPlayerToggleCaptions",
                            'togglefullscreen'                              => "ts_vcsc_extend_settings_languagePlyrPlayerToggleFullscreen",
                            'frametitle'                                    => "ts_vcsc_extend_settings_languagePlyrPlayerFrametitle",
                        ),
                        'isotopeposts'                                      => array(
                            'ButtonFilter'                                  => "ts_vcsc_extend_settings_languageIsotopePostsButtonFilter",
                            'ButtonLayout'                                  => "ts_vcsc_extend_settings_languageIsotopePostsButtonLayout",
                            'ButtonSort'                                    => "ts_vcsc_extend_settings_languageIsotopePostsButtonSort",
                            'Date'                                          => "ts_vcsc_extend_settings_languageIsotopePostsDate",
                            'Modified'                                      => "ts_vcsc_extend_settings_languageIsotopePostsModified",
                            'Title'                                         => "ts_vcsc_extend_settings_languageIsotopePostsTitle",
                            'Author'                                        => "ts_vcsc_extend_settings_languageIsotopePostsAuthor",
                            'PostID'                                        => "ts_vcsc_extend_settings_languageIsotopePostsPostID",
                            'Comments'                                      => "ts_vcsc_extend_settings_languageIsotopePostsComments",
                            'SeeAll'                                        => "ts_vcsc_extend_settings_languageIsotopePostsSeeAll",
                            'Timeline'                                      => "ts_vcsc_extend_settings_languageIsotopePostsTimeline",
                            'Masonry'                                       => "ts_vcsc_extend_settings_languageIsotopePostsMasonry",
                            'FitRows'                                       => "ts_vcsc_extend_settings_languageIsotopePostsFitRows",
                            'StraightDown'                                  => "ts_vcsc_extend_settings_languageIsotopePostsStraightDown",
                            'WooFilterProducts'                             => "ts_vcsc_extend_settings_languageIsotopePostsWooFilterProducts",
                            'WooTitle'                                      => "ts_vcsc_extend_settings_languageIsotopePostsWooTitle",
                            'WooPrice'                                      => "ts_vcsc_extend_settings_languageIsotopePostsWooPrice",
                            'WooRating'                                     => "ts_vcsc_extend_settings_languageIsotopePostsWooRating",
                            'WooDate'                                       => "ts_vcsc_extend_settings_languageIsotopePostsWooDate",
                            'WooModified'                                   => "ts_vcsc_extend_settings_languageIsotopePostsWooModified",
                            'Categories'                                    => "ts_vcsc_extend_settings_languageIsotopePostsCategories",
                            'Tags'                                          => "ts_vcsc_extend_settings_languageIsotopePostsTags",
                        ),
                    ),
                    // External Files
                    'externalfiles'                                     => array(
                        'forceloadjquery'                                   => "ts_vcsc_extend_settings_loadjQuery",
                        'forceloadcore'                                     => "ts_vcsc_extend_settings_loadForcable",
                        'forceloadhead'                                     => "ts_vcsc_extend_settings_loadHeader",
                        'forceloadstandard'                                 => "ts_vcsc_extend_settings_loadEnqueue",
                        'alwaysloadlightbox'                                => "ts_vcsc_extend_settings_loadLightbox",
                        'alwaysloadtooltips'                                => "ts_vcsc_extend_settings_loadTooltip",
                        'alwaysloadiconfonts'                               => "ts_vcsc_extend_settings_loadFonts",
                        'loadhammertwo'                                     => "ts_vcsc_extend_settings_loadHammerNew",
                        'loadmagnific'                                      => "ts_vcsc_extend_settings_loadMagnific",
                        'loadwaypoints'                                     => "ts_vcsc_extend_settings_loadWaypoints",
                        'loadmootools'                                      => "ts_vcsc_extend_settings_loadMooTools",
                        'loaddetector'                                      => "ts_vcsc_extend_settings_loadDetector",
                    ),
                    // Social Networks
                    'socialnetworks'                                    => "",
                    // WordPress Temporary Fixes
                    'wordpressfixes'                                    => array(
                        'fixjquerymigrate'                                  => "ts_vcsc_extend_settings_useFixjQueryMigrate",
                        'fixcolorpickerl10n'                                => "ts_vcsc_extend_settings_useFixColorPickerL10n",
                    ),
                    // Migration Markers
                    'migrationmarkers'                                  => array(
                        'migratesettings'                                   => "",
                    ),
                );
            }

            function TS_Settings_Migrate() {

            }

            function TS_Settings_ReadIn() {
                global $VISUAL_COMPOSER_EXTENSIONS;
                $TS_VCSC_Variable_Holder                                        = "";
                // Read-In of Inputs NOT Requiring Processing
                foreach ($this->TS_VCSC_Settings_Inputs as $TS_VCSC_Variable_ArrayKey1 => &$TS_VCSC_Variable_ArrayValue1) {
                    if (!is_array($TS_VCSC_Variable_ArrayValue1)) {
                        if (isset($this->TS_VCSC_Settings_Defaults[$TS_VCSC_Variable_ArrayKey1])) {
                            $TS_VCSC_Variable_Holder                            = $this->TS_VCSC_Settings_Defaults[$TS_VCSC_Variable_ArrayKey1];
                        } else {
                            $TS_VCSC_Variable_Holder                            = "";
                        }
                        if (!empty($TS_VCSC_Variable_ArrayValue1)) {
                            $TS_VCSC_Variable_ArrayValue1                       = $this->TS_Settings_ValueFormat($TS_VCSC_Variable_ArrayValue1, $TS_VCSC_Variable_Holder);
                        } else {

                        }
                    } else {
                        foreach ($TS_VCSC_Variable_ArrayValue1 as $TS_VCSC_Variable_ArrayKey2 => &$TS_VCSC_Variable_ArrayValue2) {
                            if (!is_array($TS_VCSC_Variable_ArrayValue2)) {
                                if (isset($this->TS_VCSC_Settings_Defaults[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2])) {
                                    $TS_VCSC_Variable_Holder                    = $this->TS_Settings_ValueFormat($TS_VCSC_Variable_ArrayValue2, $this->TS_VCSC_Settings_Defaults[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2]);
                                } else {
                                    $TS_VCSC_Variable_Holder                    = "";
                                }
                                if (!empty($TS_VCSC_Variable_ArrayValue2)) {
                                    $TS_VCSC_Variable_ArrayValue2               = $this->TS_Settings_ValueFormat($TS_VCSC_Variable_ArrayValue2, $TS_VCSC_Variable_Holder);
                                } else {

                                }
                            } else {
                                foreach ($TS_VCSC_Variable_ArrayValue2 as $TS_VCSC_Variable_ArrayKey3 => &$TS_VCSC_Variable_ArrayValue3) {
                                    if (!is_array($TS_VCSC_Variable_ArrayValue3)) {
                                        if (isset($this->TS_VCSC_Settings_Defaults[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2][$TS_VCSC_Variable_ArrayKey3])) {
                                            $TS_VCSC_Variable_Holder            = $this->TS_Settings_ValueFormat($TS_VCSC_Variable_ArrayValue3, $this->TS_VCSC_Settings_Defaults[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2][$TS_VCSC_Variable_ArrayKey3]);
                                        } else {
                                            $TS_VCSC_Variable_Holder            = "";
                                        }
                                        if (!empty($TS_VCSC_Variable_ArrayValue3)) {
                                            $TS_VCSC_Variable_ArrayValue3       = $this->TS_Settings_ValueFormat($TS_VCSC_Variable_ArrayValue3, $TS_VCSC_Variable_Holder);
                                        } else {

                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                // Read-In of Inputs WITH Further Processing
                // WP Bakery Page Builder: Main Elements
                $TS_VCSC_Variable_Elements                                      = array();
                $TS_VCSC_Variable_Deprecated                                    = array();
                $TS_VCSC_Variable_ThirdParty                                    = array();
                foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Visual_Composer_Elements as $ElementName => $element) {
                    $TS_VCSC_Variable_IsDeprecated                              = $element['deprecated'];
                    $TS_VCSC_Variable_IsExternal                                = $element['type'];
                    $TS_VCSC_Variable_ArrayKey                                  = $element['setting'];
                    $TS_VCSC_Variable_ArrayValue                                = filter_var((isset($_POST['ts_vcsc_extend_settings_custom' . $TS_VCSC_Variable_ArrayKey]) ? $_POST['ts_vcsc_extend_settings_custom' . $TS_VCSC_Variable_ArrayKey] : 0), FILTER_VALIDATE_BOOLEAN);
                    $TS_VCSC_Variable_Elements[$TS_VCSC_Variable_ArrayKey]      = $TS_VCSC_Variable_ArrayValue;
                    if ($TS_VCSC_Variable_IsDeprecated === "true") {
                        $TS_VCSC_Variable_Deprecated[$TS_VCSC_Variable_ArrayKey]                                        = $TS_VCSC_Variable_ArrayValue;
                    }
                    if ($TS_VCSC_Variable_IsExternal === "external") {
                        $TS_VCSC_Variable_ThirdParty[$TS_VCSC_Variable_ArrayKey]                                        = $TS_VCSC_Variable_ArrayValue;
                    }
                }
                $this->TS_VCSC_Settings_Inputs['pagebuildermainelements']['elementsstandard']                           = $TS_VCSC_Variable_Elements;
                // WP Bakery Page Builder: Deprecated Elements
                $this->TS_VCSC_Settings_Inputs['pagebuildermainelements']['elementsdeprecated']['deprecatedelements']   = $TS_VCSC_Variable_Deprecated;
                // WP Bakery Page Builder: 3rd Party Elements
                $this->TS_VCSC_Settings_Inputs['pagebuildermainelements']['elementsthirdparties']                       = $TS_VCSC_Variable_ThirdParty;
                // WP Bakery Page Builder: Developer Elements
                $TS_VCSC_Variable_Demos                                         = array();
                foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Visual_Composer_Demos as $ElementName => $element) {
                    $TS_VCSC_Variable_ArrayKey                                  = $element['setting'];
                    $TS_VCSC_Variable_ArrayValue                                = filter_var((isset($_POST['ts_vcsc_extend_settings_demo' . $TS_VCSC_Variable_ArrayKey]) ? $_POST['ts_vcsc_extend_settings_demo' . $TS_VCSC_Variable_ArrayKey] : 0), FILTER_VALIDATE_BOOLEAN);
                    $TS_VCSC_Variable_Demos[$TS_VCSC_Variable_ArrayKey]         = $TS_VCSC_Variable_ArrayValue;
                }
                $this->TS_VCSC_Settings_Inputs['pagebuildermainelements']['elementsdeveloper']                          = $TS_VCSC_Variable_Demos;
                // WP Bakery Page Builder: WooCommerce Elements
                $TS_VCSC_Variable_WooCommerce                                   = array();
                foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_WooCommerce_Elements as $ElementName => $element) {
                    $TS_VCSC_Variable_ArrayKey                                  = $element['setting'];
                    $TS_VCSC_Variable_ArrayValue                                = filter_var((isset($_POST['ts_vcsc_extend_settings_woocommerce' . $TS_VCSC_Variable_ArrayKey]) ? $_POST['ts_vcsc_extend_settings_woocommerce' . $TS_VCSC_Variable_ArrayKey] : 0), FILTER_VALIDATE_BOOLEAN);
                    $TS_VCSC_Variable_WooCommerce[$TS_VCSC_Variable_ArrayKey]   = $TS_VCSC_Variable_ArrayValue;
                }
                $this->TS_VCSC_Settings_Inputs['pagebuildermainelements']['elementswoocommerce']                        = $TS_VCSC_Variable_WooCommerce;
                // WP Bakery Page Builder: bbPress Elements
                $TS_VCSC_Variable_bbPress                                       = array();
                foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_bbPress_Elements as $ElementName => $element) {
                    $TS_VCSC_Variable_ArrayKey                                  = $element['setting'];
                    $TS_VCSC_Variable_ArrayValue                                = filter_var((isset($_POST['ts_vcsc_extend_settings_bbpress' . $TS_VCSC_Variable_ArrayKey]) ? $_POST['ts_vcsc_extend_settings_bbpress' . $TS_VCSC_Variable_ArrayKey] : 0), FILTER_VALIDATE_BOOLEAN);
                    $TS_VCSC_Variable_bbPress[$TS_VCSC_Variable_ArrayKey]       = $TS_VCSC_Variable_ArrayValue;
                }
                $this->TS_VCSC_Settings_Inputs['pagebuildermainelements']['elementsbbpress']                            = $TS_VCSC_Variable_bbPress;
                // WP Bakery Page Builder: Icon Fonts
                if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorIconFontsInternal == "true") {
                    foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Composer_Font_Settings as $Icon_Font => $iconfont) {
                        $fontActivate 	                                = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_tinymce' . $iconfont['setting']])) ? $_POST['ts_vcsc_extend_settings_tinymce' . $iconfont['setting']] : 0)), FILTER_VALIDATE_BOOLEAN);
                        $fontLoad 		                                = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_load' . $iconfont['setting']])) ? $_POST['ts_vcsc_extend_settings_load' . $iconfont['setting']] : 0)), FILTER_VALIDATE_BOOLEAN);
                        //update_option('ts_vcsc_extend_settings_tinymce' . $iconfont['setting'],		$fontActivate);
                        //update_option('ts_vcsc_extend_settings_load' . $iconfont['setting'],		$fontLoad);
                    }
                }
                // Composium Icon Fonts
                foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Icon_Font_Settings as $Icon_Font => $iconfont) {
                    if (($iconfont['setting'] == 'Custom') && (get_option('ts_vcsc_extend_settings_tinymceCustomArray', '') != '')) {
                        $fontActivate 	                                = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_tinymce' . $iconfont['setting']])) ? $_POST['ts_vcsc_extend_settings_tinymce' . $iconfont['setting']] : 0)), FILTER_VALIDATE_BOOLEAN);
                        $fontLoad 		                                = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_load' . $iconfont['setting']])) ? $_POST['ts_vcsc_extend_settings_load' . $iconfont['setting']] : 0)), FILTER_VALIDATE_BOOLEAN);
                        //update_option('ts_vcsc_extend_settings_tinymce' . $iconfont['setting'],		$fontActivate);
                        //update_option('ts_vcsc_extend_settings_load' . $iconfont['setting'],		$fontLoad);
                    } else if ($iconfont['setting'] != 'Custom'){
                        $fontActivate 	                                = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_tinymce' . $iconfont['setting']])) ? $_POST['ts_vcsc_extend_settings_tinymce' . $iconfont['setting']] : 0)), FILTER_VALIDATE_BOOLEAN);
                        $fontLoad 		                                = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_load' . $iconfont['setting']])) ? $_POST['ts_vcsc_extend_settings_load' . $iconfont['setting']] : 0)), FILTER_VALIDATE_BOOLEAN);
                        //update_option('ts_vcsc_extend_settings_tinymce' . $iconfont['setting'],		$fontActivate);
                        //update_option('ts_vcsc_extend_settings_load' . $iconfont['setting'],		$fontLoad);
                    }
                }
                // Kraut Lightbox Settings
                $TS_VCSC_Variable_KillLight                                     = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_defaultLightboxBacklight'])) ? $_POST['ts_vcsc_extend_settings_defaultLightboxBacklight'] : 0)), FILTER_VALIDATE_BOOLEAN);
                $TS_VCSC_Variable_CustomLight                                   = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_defaultLightboxBackCustom'])) ? $_POST['ts_vcsc_extend_settings_defaultLightboxBackCustom'] : 0)), FILTER_VALIDATE_BOOLEAN);
                $TS_VCSC_Variable_CustomColor                                   = trim(((isset($_POST['ts_vcsc_extend_settings_defaultLightboxBackColor'])) ? $_POST['ts_vcsc_extend_settings_defaultLightboxBackColor'] : '#ffffff'));
                $TS_VCSC_Variable_ShareNetworks                                 = preg_replace("/[^a-zA-Z,]/", "", $_POST['ts_vcsc_extend_settings_defaultLightboxNetworks']);
                $TS_VCSC_Variable_DefaultSocialAPIs                             = filter_var(intval(((isset($_POST['ts_vcsc_extend_settings_defaultLightboxLoadAPIs'])) ? $_POST['ts_vcsc_extend_settings_defaultLightboxLoadAPIs'] : 0)), FILTER_VALIDATE_BOOLEAN);
                $TS_VCSC_Variable_DefaultAnimation                              = trim(((isset($_POST['ts_vcsc_extend_settings_defaultLightboxAnimation'])) ? $_POST['ts_vcsc_extend_settings_defaultLightboxAnimation'] : 'random'));
                if (($TS_VCSC_Variable_KillLight === false) && ($TS_VCSC_Variable_CustomLight === true)) {
                    $TS_VCSC_Variable_ColorUsage                        = true;
                    $TS_VCSC_Variable_ColorBacklight                    = $TS_VCSC_Variable_CustomColor;
                } else if (($TS_VCSC_Variable_KillLight === true) && ($TS_VCSC_Variable_CustomLight === false)) {
                    $TS_VCSC_Variable_ColorUsage                        = true;
                    $TS_VCSC_Variable_ColorBacklight                    = "";
                } else if (($TS_VCSC_Variable_KillLight === true) && ($TS_VCSC_Variable_CustomLight === true)) {
                    $TS_VCSC_Variable_ColorUsage                        = true;
                    $TS_VCSC_Variable_ColorBacklight                    = "";
                } else if (($TS_VCSC_Variable_KillLight === false) && ($TS_VCSC_Variable_CustomLight === false)) {
                    $TS_VCSC_Variable_ColorUsage                        = false;
                    $TS_VCSC_Variable_ColorBacklight                    = "#ffffff";
                } else {
                    $TS_VCSC_Variable_ColorUsage                        = false;
                    $TS_VCSC_Variable_ColorBacklight                    = "#ffffff";
                }
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['animation']                    = $TS_VCSC_Variable_DefaultAnimation;
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['social']                       = strtolower($TS_VCSC_Variable_ShareNetworks);
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['removelight']                  = $TS_VCSC_Variable_KillLight;
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['customlight']                  = $TS_VCSC_Variable_CustomLight;
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['customcolor']                  = $TS_VCSC_Variable_CustomColor;
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['customcolor']                  = $TS_VCSC_Variable_CustomColor;
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['backlight']                    = $TS_VCSC_Variable_ColorBacklight;
                $this->TS_VCSC_Settings_Inputs['krautlightbox']['uselightboxinternals']['usecolor']                     = $TS_VCSC_Variable_ColorUsage;
                // Social Network Settings
                $socialnetwork_defaults_names                                   = array();
                $socialnetwork_defaults_datas                                   = array();
                $socialnetwork_defaults_combo                                   = array();
                foreach ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Social_Networks_Array as $Social_Network => $social) {
                    $social_defaults                                            = array(
                        'link'                                                  => trim ($_POST['ts_vcsc_social_link_' . $Social_Network]),
                        'order'                                                 => trim ($_POST['ts_vcsc_social_order_' . $Social_Network]),
                        'original'                                              => $social['order'],
                        'icon'                                                  => $social['icon'],
                    );
                    array_push($socialnetwork_defaults_names, $Social_Network);
                    $socialnetwork_defaults_datas[]                             = $social_defaults;		
                }
                $socialnetwork_defaults_combo 		                            = array_combine($socialnetwork_defaults_names, $socialnetwork_defaults_datas);
                $this->TS_VCSC_Settings_Inputs['socialnetworks']                = $socialnetwork_defaults_combo;
                unset($socialnetwork_defaults_names);
                unset($socialnetwork_defaults_datas);
                unset($socialnetwork_defaults_combo);
                // Remove Variables From Memory
                foreach($this->TS_VCSC_Settings_UnsetMe as $UnsetMe => $variable) {
                    unset(${$variable});
                };


                var_dump($this->TS_VCSC_Settings_Inputs);
            }

            function TS_Settings_ReadOut() {
                $this->TS_VCSC_Settings_Custom                          = get_option('ts_vcsc_extend_settings_customsettings', array());
                $this->TS_Settings_Validation();
            }

            function TS_Settings_Validation() {
                $this->TS_VCSC_Settings_Finalized                       = $this->TS_Settings_ArrayClone($this->TS_VCSC_Settings_Defaults);
                foreach ($this->TS_VCSC_Settings_Finalized as $TS_VCSC_Variable_ArrayKey1 => &$TS_VCSC_Variable_ArrayValue1) {
                    if (!is_array($TS_VCSC_Variable_ArrayValue1)) {
                        if (isset($this->TS_VCSC_Settings_Custom[$TS_VCSC_Variable_ArrayKey1])) {
                            $TS_VCSC_Variable_ArrayValue1                                     = $this->TS_VCSC_Settings_Custom[$TS_VCSC_Variable_ArrayKey1];
                        }
                        //echo $TS_VCSC_Variable_ArrayKey1 . ' / ' . $TS_VCSC_Variable_ArrayValue1 . ' / ' . gettype($TS_VCSC_Variable_ArrayValue1) . ' / 1<br/>';
                    } else {
                        foreach ($TS_VCSC_Variable_ArrayValue1 as $TS_VCSC_Variable_ArrayKey2 => &$TS_VCSC_Variable_ArrayValue2) {
                            if (!is_array($TS_VCSC_Variable_ArrayValue2)) {
                                if (isset($this->TS_VCSC_Settings_Custom[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2])) {
                                    $TS_VCSC_Variable_ArrayValue2                             = $this->TS_VCSC_Settings_Custom[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2];
                                }
                                //echo $TS_VCSC_Variable_ArrayKey2 . ' / ' . $TS_VCSC_Variable_ArrayValue2 . ' / ' . gettype($TS_VCSC_Variable_ArrayValue2) . ' / 2<br/>';
                            } else {
                                foreach ($TS_VCSC_Variable_ArrayValue2 as $TS_VCSC_Variable_ArrayKey3 => &$TS_VCSC_Variable_ArrayValue3) {
                                    if (!is_array($TS_VCSC_Variable_ArrayValue3)) {
                                        if (isset($this->TS_VCSC_Settings_Custom[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2][$TS_VCSC_Variable_ArrayKey3])) {
                                            $TS_VCSC_Variable_ArrayValue3                     = $this->TS_VCSC_Settings_Custom[$TS_VCSC_Variable_ArrayKey1][$TS_VCSC_Variable_ArrayKey2][$TS_VCSC_Variable_ArrayKey3];
                                        }
                                        //echo $TS_VCSC_Variable_ArrayKey3 . ' / ' . $TS_VCSC_Variable_ArrayValue3 . ' / ' . gettype($TS_VCSC_Variable_ArrayValue3) . ' / 3<br/>';
                                    }
                                }
                            }
                       }
                    }
                }
                //unset($this->TS_VCSC_Settings_Custom);
            }

            function TS_Settings_ValueFormat($input, $default) {
                if (($input === "") || (empty($input))) {
                    return "";
                }                
                if (gettype($default) === "integer") {                    
                    return intval(((isset($_POST[$input])) ? $_POST[$input] : $default));
                } else if (gettype($default) === "boolean") {
                    return (isset($_POST[$input]) ? filter_var($_POST[$input], FILTER_VALIDATE_BOOLEAN) : filter_var($default, FILTER_VALIDATE_BOOLEAN));
                } else if (gettype($default) === "object") {
                    return "";
                } else if (gettype($default) === "array") {
                    return "";
                } else if (gettype($default) === "NULL") {
                    return "";
                } else {
                    return trim(((isset($_POST[$input])) ? $_POST[$input] : $default));
                }
            }

            function TS_Settings_ArrayClone($array) {
                return array_map(function($element) {
                    return ((is_array($element)) ? $this->TS_Settings_ArrayClone($element) : ((is_object($element)) ? clone $element : $element));
                }, $array);
            }

            function TS_Settings_ArrayCompare($array1, $array2){
                $result = array("more"=>array(),"less"=>array(),"diff"=>array());
                foreach($array1 as $k => $v) {
                    if(is_array($v) && isset($array2[$k]) && is_array($array2[$k])){
                        $sub_result = $this->TS_Settings_ArrayCompare($v, $array2[$k]);
                        //merge results
                        foreach(array_keys($sub_result) as $TS_VCSC_Variable_ArrayKey){
                            if(!empty($sub_result[$TS_VCSC_Variable_ArrayKey])){
                                $result[$TS_VCSC_Variable_ArrayKey] = array_merge_recursive($result[$TS_VCSC_Variable_ArrayKey],array($k => $sub_result[$TS_VCSC_Variable_ArrayKey]));
                            }
                        }
                    }else{
                        if(isset($array2[$k])){
                            if($v !== $array2[$k]){
                                $result["diff"][$k] = array("from"=>$v,"to"=>$array2[$k]);
                            }
                        }else{
                            $result["more"][$k] = $v;
                        }
                    }
                }
                foreach($array2 as $k => $v) {
                    if(!isset($array1[$k])){
                        $result["less"][$k] = $v;
                    }
                }
                return $result;
            }

            function TS_Settings_ArrayKeyExists(Array $array, $TS_VCSC_Variable_ArrayKey) {
                if (array_key_exists($TS_VCSC_Variable_ArrayKey, $array)) return true;
                foreach ($array as $k=>$v) {
                    if (!is_array($v)) continue;
                    if (array_key_exists($TS_VCSC_Variable_ArrayKey, $v)) return true;
                }
                return false;
            }
		}
	}
    // Initialize "TS_COMPOSIUM_SETTINGS" Class
    global $TS_COMPOSIUM_SETTINGS;
	if (class_exists('TS_COMPOSIUM_SETTINGS')) {
		$TS_COMPOSIUM_SETTINGS = new TS_COMPOSIUM_SETTINGS;
	}
?>